% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQualtrics.R
\name{getSurvey}
\alias{getSurvey}
\title{Alias for 'qualtrics'}
\usage{
getSurvey(
  qualtrics_alias,
  institution = NULL,
  label = FALSE,
  interview_date = NULL
)
}
\arguments{
\item{qualtrics_alias}{The alias for the Qualtrics survey to be retrieved.}

\item{institution}{Optional. The institution name (e.g., "temple" or "nu"). If NULL, all institutions will be searched.}

\item{label}{Logical indicating whether to return coded values or their associated labels (default is FALSE).}

\item{interview_date}{Optional; can be either:
- A date string in various formats (ISO, US, etc.) to filter data up to that date
- A boolean TRUE to return only rows with non-NA interview_date values}
}
\value{
A cleaned and harmonized data frame containing the survey data with superkeys first.
}
\description{
This is a legacy alias for the 'qualtrics' function to maintain compatibility with older code.
}
\examples{
\dontrun{
survey_data <- getSurvey("your_survey_alias")
}
}
