% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_min.R
\name{row_min}
\alias{row_min}
\alias{row_min.matrix}
\alias{row_min.data.frame}
\title{Row-wise minima}
\usage{
row_min(.data, which = NULL, ...)

\method{row_min}{matrix}(.data, which = NULL, ...)

\method{row_min}{data.frame}(.data, which = NULL, ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{which}{If not \code{NULL}, one of ("first", "last") to return the index where minima occurs.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{output_class}}{One of ("vector", "list", "data.frame", "matrix"), possibly abbreviated.}
    \item{\code{na_action}}{One of ("exclude", "pass"), possibly abbreviated. See \link[stats:na.pass]{stats::na.pass} for
semantics.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
    \item{\code{factor_mode}}{One of ("character", "integer"), possibly abbreviated. If a column is a
factor, this determines whether the operation uses its internal integer values, or the
character values from its levels.}
  }}
}
\description{
Row-wise minima
}
\details{
For data frames, if the input columns have different modes, all of them will be promoted
on-the-fly to the highest one in the R hierarchy.
}
\note{
String comparison is done in C++, which can vary from what R does.
}
\examples{

df <- data.frame(FALSE, TRUE, NA_character_)

# all columns promoted to character (on-the-fly)
row_min(df)
row_min(df, na_action = "pass")

# no promotion
row_min(df, cols = 1:2)

row_min(df, cols = 1:2, which = "last")

}
