% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot a heatmap of selected grid cells}
\usage{
plot_heatmap(result, si = 2, idistw)
}
\arguments{
\item{result}{The output of \code{\link{windfarmGA}} or
\code{\link{genetic_algorithm}}}

\item{si}{A numeric value that is used for the sizing of the resolution of
the heatmap. Default is 2}

\item{idistw}{The inverse distance weighting power. Default is the rotor
radius from the 'result' values}
}
\value{
Invisibly returns a list with the result of the inverse distance
  weighting and an aggregated dataframe of all grid cells
}
\description{
Plot a heatmap of selected grid cells. Green grid cells
  have been selected more often than red grid cells.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
plot_heatmap(resulthex)

## Plot the heatmap with different settings
plot_heatmap(resulthex, si = 6, idistw = 2)
plot_heatmap(resulthex, si = 6, idistw = 100)
plot_heatmap(resulthex, si = 20, idistw = 10)
}
}
\seealso{
Other Plotting Functions: 
\code{\link{interpol_view}()},
\code{\link{plot_cloud}()},
\code{\link{plot_development}()},
\code{\link{plot_evolution}()},
\code{\link{plot_fitness_evolution}()},
\code{\link{plot_parkfitness}()},
\code{\link{plot_result}()},
\code{\link{plot_viewshed}()},
\code{\link{plot_windfarmGA}()},
\code{\link{plot_windrose}()},
\code{\link{random_search_single}()}
}
\concept{Plotting Functions}
