% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{create_heatmap}
\alias{create_heatmap}
\title{Method for heatmap creation}
\usage{
create_heatmap(data, unitlabel = "auto", row.label = TRUE,
  row.custom.label = NULL, column.label = TRUE,
  column.custom.label = NULL, clustering = "none",
  clustdist = "auto", clustmethod = "auto", colors = NULL,
  winsorize.colors = NULL, plot.method = "static", width = "auto",
  height = "auto", ppi = 72, scale = 1)
}
\arguments{
\item{data}{data.table containing plot data. First column contains row labels.}

\item{unitlabel}{label of the colorbar}

\item{row.label}{Logical whether or not to show row labels.}

\item{row.custom.label}{Vector of custom row labels.}

\item{column.label}{Logical whether or not to show column labels.}

\item{column.custom.label}{Vector of custom column labels.}

\item{clustering}{How to apply clustering on data. c("none", "both", "column", "row")}

\item{clustdist}{Which cluster distance to use. See \code{\link[heatmaply]{heatmapr}}.}

\item{clustmethod}{Which cluster method to use. See \code{\link[heatmaply]{heatmapr}}.}

\item{colors}{Vector of colors used for color palette.}

\item{winsorize.colors}{NULL or a vector of length two, giving the values of colorbar ends (default = NULL).}

\item{plot.method}{Choose which method is used for plotting. Either "plotly" or "complexHeatmap" (Default = "complexHeatmap").}

\item{width}{Set width of plot in cm (Default = "auto").}

\item{height}{Set height of plot in cm (Default = "auto").}

\item{ppi}{Pixel per inch (default = 72).}

\item{scale}{Modify plot size while preserving aspect ratio (Default = 1).}
}
\value{
Returns list(plot = complexHeatmap/ plotly object, width = width in cm, height = height in cm, ppi = pixel per inch, exceed_size = Boolean whether width/ height exceeded max) depending on plot.method.
}
\description{
Method for heatmap creation
}
\details{
Width/ height limit = 500. If exceeded default to 500 and issue exceed_size = TRUE.
}
