% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-history-count.R
\name{get_history_count}
\alias{get_history_count}
\title{Count how many times Wikipedia articles have been edited}
\usage{
get_history_count(
  title,
  type = c("edits", "anonymous", "bot", "editors", "minor", "reverted"),
  from = NULL,
  to = NULL,
  language = "en"
)
}
\arguments{
\item{title}{A vector of article titles}

\item{type}{The \href{https://www.mediawiki.org/wiki/API:REST_API/Reference#Parameters_12}{type of edit to count}}

\item{from}{Optional: a vector of revision ids}

\item{to}{Optional: a vector of revision ids}

\item{language}{Vector of two-letter language codes for Wikipedia editions}
}
\value{
A \link[tibble:tbl_df-class]{tibble::tbl_df} with two columns:
\itemize{
\item 'count': integer, the number of edits of the given type
\item 'limit': logical, whether the 'count' exceeds the API's limit. Each type of
edit has a different limit. If the 'count' exceeds the limit, then the
limit is returned as the count and 'limit' is set to TRUE
}
}
\description{
Count how many times Wikipedia articles have been edited
}
\examples{
# Get the number of edits made by auto-confirmed editors to a page between
# revisions 384955912 and 406217369
get_history_count("Jupiter", "editors", 384955912, 406217369)

# Compare which authors have the most edit activity
authors <- tibble::tribble(
  ~author,
  "Jane Austen",
  "William Shakespeare",
  "Emily Dickinson"
) \%>\%
  dplyr::mutate(get_history_count(author))
authors
}
