% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_isValid}
\alias{w_isValid}
\title{Check if a Wikidata entity is valid}
\usage{
w_isValid(entity_list, nlimit = 50000)
}
\arguments{
\item{entity_list}{A vector with de Wikidata entities.}

\item{nlimit}{If the number of entities exceeds this number, chunked queries
are done. This is the number of entities requested in each chunk.}
}
\value{
A data-frame with three columns: firts, the entity itself, second,
if that entity is valid in Wikidata (TRUE or FALSE), last, if the entity
redirects to another Wikidata entity, this entity.
}
\description{
Check if the Wikidata entities are valid. A entity is valid if it has a label
or has a description. If one entity exists but is not valid, is possible that
it has a redirection to other entity, in that case, the redirection is
obtained. Other entities may have existed in the past, but have been deleted.
Duplicated entities in entity_list are deleted before checking. Index of the
data-frame returned are also set to entity_list.
}
\examples{
\dontrun{
w_isValid(c("Q9021", "Q115637688", "Q105660123"))

l  <- w_OccupationEntities(Qoc='Q2306091')
l2 <- append(l, c("Q115637688", "Q105660123"))  # Note: adding two new entities
v <- w_isValid(l2)
# Not valid
v[!v$valid,]
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
