% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_SearchByOccupation}
\alias{w_SearchByOccupation}
\title{Get Wikidata entities with a certain occupation}
\usage{
w_SearchByOccupation(
  Qoc,
  mode = c("default", "count", "wikipedias"),
  langsorder = "",
  wikilangs = "",
  nlimit = 10000,
  debug = FALSE
)
}
\arguments{
\item{Qoc}{The Wikidata entity of the occupation. For example, Q2306091 for
sociologist, Q2526255 for Film director, etc.}

\item{mode}{The results you want to obtain: 'default' returns the Wikidata
entities which have the occupation indicated; 'count' search in WDQS to know
the number of Wikidata entities with that occupation); 'wikipedias' also the
Wikipedia page of the entities are returned.}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. If langsorder='', then labels or descriptions
are not returned.}

\item{wikilangs}{List of languages in Wikipedias to limit the search, using
"|" as separator (only if mode='wikipedias'). Wikipedias page titles are
returned in same order as languages in this parameter. If wikilangs='' the
function returns Wikipedia page titles of entities in any language, not
sorted.}

\item{nlimit}{If the number of entities in that occupation exceeds this
number, then query are made in chunks. The value can increase if
\code{langorder}=''. Please, reduce the default value if error is raised.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown. If debug='count' the function only returns the number of
entities with that occupation.}
}
\value{
A data-frame with 'entity' and  'entityLabel', 'entityDescription',
'instanceof' and 'instanceofLabel' columns. Index of the data-frame
is also set to the list of entities found.
}
\description{
Return the Wikidata entities which have the occupation indicated in \code{Qoc},
the Wikidata entity for that occupation. For example, if Qoc='Q2306091',
returns the Wikidata entities which occupation is "Sociologist", among
others. Also returns the Wikidata class of which the entities are instances
of. If parameter langsorder='', then no labels or descriptions of the
entities are returned, otherwise the function returns them in the language
order indicated in \code{langsorder}. If wikilangs='' (if mode='wikipedias') then
the Wikipedia pages are not filtered by language, else only Wikipedias of
languages in this parameter are returned.
}
\examples{
\dontrun{
# "Q2306091" Qoc for Sociologist
w_SearchByOccupation(Qoc="Q2306091", mode='count')
q <- w_SearchByOccupation(Qoc="Q2306091", langsorder="")
q <- w_SearchByOccupation(Qoc="Q2306091", langsorder="en|es|fr")
q <- w_SearchByOccupation(Qoc="Q2306091", mode='wikipedias', debug='info')
q <- w_SearchByOccupation(Qoc="Q2306091", mode='wikipedias', wikilangs='en|es|fr', debug='info')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
