% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{wbt_knn_classification}
\alias{wbt_knn_classification}
\title{Knn classification}
\usage{
wbt_knn_classification(
  inputs,
  training,
  field,
  output,
  scaling = "Normalize",
  k = 5,
  clip = TRUE,
  test_proportion = 0.2,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Names of the input predictor rasters.}

\item{training}{Name of the input training site polygons/points shapefile.}

\item{field}{Name of the attribute containing class name data.}

\item{output}{Name of the output raster file.}

\item{scaling}{Scaling method for predictors. Options include 'None', 'Normalize', and 'Standardize'.}

\item{k}{k-parameter, which determines the number of nearest neighbours used.}

\item{clip}{Perform training data clipping to remove outlier pixels?.}

\item{test_proportion}{The proportion of the dataset to include in the test split; default is 0.2.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a supervised k-nearest neighbour classification using training site polygons/points and predictor rasters.
}
