% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supply_use.R
\name{build_supply_use}
\alias{build_supply_use}
\title{Supply and use tables}
\usage{
build_supply_use(
  cbs_version = NULL,
  feed_intake_version = NULL,
  primary_prod_version = NULL,
  primary_residues_version = NULL,
  processing_coefs_version = NULL
)
}
\arguments{
\item{cbs_version}{File version passed to \code{get_wide_cbs()} call.}

\item{feed_intake_version}{File version passed to \code{get_feed_intake()} call.}

\item{primary_prod_version}{File version passed to
\code{get_primary_production()} call.}

\item{primary_residues_version}{File version passed to
\code{get_primary_residues()} call.}

\item{processing_coefs_version}{File version passed to
\code{get_processing_coefs()} call.}
}
\value{
A tibble with the supply and use data for processes.
It contains the following columns:
\itemize{
\item \code{year}: The year in which the recorded event occurred.
\item \code{area_code}: The code of the country where the data is from. For code
details see e.g. \code{add_area_name()}.
\item \code{proc_group}: The type of process taking place. It can be one of:
\itemize{
\item \code{crop_production}: Production of crops and their residues, e.g. rice
production, coconut production, etc.
\item \code{husbandry}: Animal husbandry, e.g. dairy cattle husbandry, non-dairy
cattle husbandry, layers chickens farming, etc.
\item \code{processing}: Derived subproducts obtained from processing other items.
The items used as inputs are those that have a non-zero processing use in
the commodity balance sheet. See \code{get_wide_cbs()} for more details.
In each process there is a single input. In some processes like olive oil
extraction or soyabean oil extraction this might make sense. Others like
alcohol production need multiple inputs (e.g. multiple crops work), so
in this data there would not be a process like alcohol production but
rather a \emph{virtual} process like 'Wheat and products processing', giving
all its possible outputs. This is a constraint because of how the data was
obtained and might be improved in the future. See
\code{get_processing_coefs()} for more details.
}
\item \code{proc_cbs_code}: The code of the main item in the process taking place.
Together with \code{proc_group}, these two columns uniquely represent a
process. The main item is predictable depending on the value of
\code{proc_group}:
\itemize{
\item \code{crop_production}: The code is from the item for which seed usage
(if any) is reported in the commodity balance sheet (see
\code{get_wide_cbs()} for more). For example, the rice code for a rice
production process or the cottonseed code for the cotton production one.
\item \code{husbandry}: The code of the farmed animal, e.g. bees for beekeeping,
non-dairy cattle for non-dairy cattle husbandry, etc.
\item \code{processing}: The code of the item that is used as input, i.e., the one
that is processed to get other derived products. This uniquely defines a
process within the group because of the nature of the data that was used,
which you can see in \code{get_processing_coefs()}.
}

For code details see e.g. \code{add_item_cbs_name()}.
\item \code{item_cbs_code}: The code of the item produced or used in the process.
Note that this might be the same value as \code{proc_cbs_code}, e.g., in rice
production process for the row defining the amount of rice produced or
the amount of rice seed as input, but it might also have a different
value, e.g. for the row defining the amount of straw residue from rice
production. For code details see e.g. \code{add_item_cbs_name()}.
\item \code{type}: Can have two values:
\itemize{
\item \code{use}: The given item is an input of the process.
\item \code{supply}: The given item is an output of the process.
}
\item \code{value}: Quantity in tonnes.
}
}
\description{
Create a table with processes, their inputs (\emph{use}) and their
outputs (\emph{supply}).
}
\examples{
# Note: These are smaller samples to show outputs, not the real data.
# For all data, call the function with default versions (i.e. no arguments).
build_supply_use(
  cbs_version = "20250721T132006Z-8ea47",
  feed_intake_version = "20250721T143825Z-c1313",
  primary_prod_version = "20250721T145805Z-8e12a",
  primary_residues_version = "20250721T150132Z-dfd94",
  processing_coefs_version = "20250721T143403Z-216d7"
)
}
