\name{varplot}
\alias{varplot}
\title{Plot theoretical and estimated variances of Wstar}
\usage{
  varplot(Wstar, n1, n2)
}
\arguments{
  \item{Wstar}{the vector of Wilcoxon values generated by
  permutation}

  \item{n1}{number of items (SNPs) in regions to be
  tested.}

  \item{n2}{number of items (SNPs) in regions the control
  regions.}
}
\value{
  None
}
\description{
  Given a vector of Wilcoxon statistics generated through
  permutation, plot theoretical and esitimated variance by
  cumulative number of permutations
}
\examples{
x<- matrix(exp(-rexp(200000)),nrow=2000)
Wstar<-wilcoxon(p=x,snps.in=1:1000)
varplot(Wstar=Wstar,1000,1000)
}
\author{
  Chris Wallace <chris.wallace at cimr.cam.ac.uk>
}
\seealso{
  \code{\link{wilcoxon}}
}
\keyword{plot}

