% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagplot.R
\name{gg_bagplot}
\alias{gg_bagplot}
\title{Bagplot}
\usage{
gg_bagplot(
  data,
  var1,
  var2,
  col = c(hdr_palette(color = "#00659e", prob = c(0.5, 0.99)), "#000000"),
  scatterplot = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame or matrix containing the data.}

\item{var1}{The name of the first variable to plot (a bare expression).}

\item{var2}{The name of the second variable to plot (a bare expression).}

\item{col}{The colors to use in the order: median, bag, loop and outliers.}

\item{scatterplot}{A logical argument indicating if a regular bagplot is required
(\code{FALSE}), or if a scatterplot in the same colors is required (\code{TRUE}).}

\item{...}{Other arguments are passed to the \code{\link[aplpack]{compute.bagplot}} function.}
}
\value{
A ggplot object showing a bagplot or scatterplot of the data.
}
\description{
Produces a bivariate bagplot. A bagplot is analagous to a
univariate boxplot, except it is in two dimensions. Like a boxplot, it
shows the median, a region containing 50\% of the observations, a region
showing the remaining observations other than outliers, and any outliers.
}
\examples{
gg_bagplot(n01, v1, v2)
gg_bagplot(n01, v1, v2, scatterplot = TRUE)
}
\references{
Rousseeuw, P. J., Ruts, I., & Tukey, J. W. (1999).
The bagplot: A bivariate boxplot. \emph{The American Statistician}, \bold{52}(4), 382–387.
}
\seealso{
\code{\link[aplpack]{bagplot}}
}
\author{
Rob J Hyndman
}
