% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simpleWeight.R
\docType{methods}
\name{simpleWeight}
\alias{simpleWeight}
\alias{simpleWeight,ANY-method}
\title{Find weights for survey data}
\usage{
simpleWeight(data, pop.margins, names = c(~agegend, ~ethm, ~educat, ~regmetro,
  ~incomcat, ~ppnet), trunc_at = 5)
}
\arguments{
\item{data}{A dataframe of observations and values for population categories}

\item{pop.margins}{A list of known population parameters}

\item{names}{The names of the population parameters. The dataframe MUST include variables with the same names as the population parameters specified.}

\item{trunc_at}{A numeric object specifying where to truncate the weights (what should the max weight be?) - default is 5}
}
\value{
A vector of weights
}
\description{
Find weights for survey from a dataframe of observations and population margins. This function performs a raking process based on the population margins specified by the user.
}
\author{
David G. Carlson \email{carlson.david@wustl.edu}  Michelle Torres: \email{smtorres@wustl} Taeyong Park \email{t.park@wustl.edu}
}
\seealso{
\code{\link{weightTAPSPACK}} \code{\link{weightTAPS}} \code{\link{variablesTAPS}} \code{\link{weightTAPSoutput}} \code{\link{subsetTAPS}} \code{\link{attritTAPS}} \code{\link{multipleImp}} \code{\link{hotdeckImp}} \code{\link{wavesTAPS}}
}

