% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\encoding{UTF-8}
\name{plot_conf}
\alias{plot_conf}
\alias{plot_conf.wt_confint}
\title{Add Confidence Region(s) for Quantiles and Probabilities}
\usage{
plot_conf(p_obj, x, ...)

\method{plot_conf}{wt_confint}(
  p_obj,
  x,
  title_trace_mod = "Fit",
  title_trace_conf = "Confidence Limit",
  ...
)
}
\arguments{
\item{p_obj}{A plot object returned from \code{\link{plot_prob}}.}

\item{x}{Confidence interval as returned by \code{\link{confint_betabinom}}
or \code{\link{confint_fisher}}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{title_trace_mod}{A character string which is assigned to the mod trace
in the legend.}

\item{title_trace_conf}{A character string which is assigned to the conf trace
in the legend.}
}
\value{
Returns a plot object containing the probability plot with
  plotting positions, the estimated regression line and the estimated
  confidence region(s).
}
\description{
This function is used to add estimated confidence region(s) to an existing
probability plot. Since confidence regions are related to the estimated
regression line, the latter is provided as well.
}
\examples{
# Reliability data:
data <- reliability_data(data = alloy, x = cycles, status = status)

# Probability estimation:
prob_tbl <- estimate_cdf(data, methods = "johnson")

# Example 1 - Probability Plot, Regression Line and Confidence Bounds for Three-Parameter-Weibull:
rr <- rank_regression(prob_tbl, distribution = "weibull3")

conf_betabin <- confint_betabinom(rr)

plot_weibull <- plot_prob(prob_tbl, distribution = "weibull")

plot_conf_beta <- plot_conf(
  p_obj = plot_weibull,
  x = conf_betabin
)

# Example 2 - Probability Plot, Regression Line and Confidence Bounds for Three-Parameter-Lognormal:
rr_ln <- rank_regression(
  prob_tbl,
  distribution = "lognormal3",
  conf_level = 0.9
)

conf_betabin_ln <- confint_betabinom(
  rr_ln,
  bounds = "two_sided",
  conf_level = 0.9,
  direction = "y"
)

plot_lognormal <- plot_prob(prob_tbl, distribution = "lognormal")

plot_conf_beta_ln <- plot_conf(
  p_obj = plot_lognormal,
  x = conf_betabin_ln
)

# Example 3 - Probability Plot, Regression Line and Confidence Bounds for MLE
ml <- ml_estimation(data, distribution = "weibull")

conf_fisher <- confint_fisher(ml)

plot_weibull <- plot_prob(prob_tbl, distribution = "weibull")

plot_conf_fisher_weibull <- plot_conf(
  p_obj = plot_weibull,
  x = conf_fisher
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
