% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimators.R
\encoding{UTF-8}
\name{rank_regression}
\alias{rank_regression}
\title{Rank Regression for Parametric Lifetime Distributions}
\usage{
rank_regression(x, y, event, distribution = c("weibull", "lognormal",
  "loglogistic", "normal", "logistic", "sev", "weibull3", "lognormal3",
  "loglogistic3"), conf_level = 0.95, details = TRUE)
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{a numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{details}{a logical variable, where the default value is \code{TRUE}.
If \code{FALSE} the output consists of a list that only contains the
estimated parameters. If \code{TRUE} the output is a detailed list with
many more information. See below (\strong{Value}).}
}
\value{
Returns a list with the following components (depending on
  \code{details} argument):
  \itemize{
  \item \code{coefficients} : Provided, if \code{distribution} is \code{"weibull"}
    or \code{"weibull3"}. \eqn{\eta} is the estimated scale and \eqn{\beta}
    the estimated shape parameter. The estimated threshold parameter \eqn{\gamma}
    is available if the three-parametric weibull is used.
  \item \code{confint} : Provided, if \code{distribution} is \code{"weibull"}
    or \code{"weibull3"}. Confidence intervals for \eqn{\eta} and \eqn{\beta}
    (and \eqn{\gamma} if the three-parametric weibull is used).
  \item \code{loc_sc_coefficients} : Estimated location-scale parameters.
    Threshold parameter is provided for \code{"weibull3"}, \code{"lognormal3"}
    and \code{"loglogistic3"}.
  \item \code{loc_sc_confint} : Confidence intervals for location-scale parameters.
    If distribution is \code{"lognormal3"} or \code{"loglogistic3"} a confidence
    interval for the threshold is not computed.
  \item \code{loc_sc_vcov} : Provided, if \code{distribution} is not
    \code{"weibull"} or \code{"weibull3"}. Estimated heteroscedasticity-consistent
    Variance-Covariance matrix of the used location-scale distribution.
  \item \code{r_squared} : Coefficient of determination.}
}
\description{
This method fits an \strong{x on y} regression to a linearized
two- or three-parameter cdf and is applicable for complete and (multiple) right
censored data. The parameters are estimated in the frequently used (log-) location-scale
parameterization. For the Weibull, estimates are transformed such that
they are in line with the parameterization provided by the \emph{stats} package
like \code{\link{pweibull}}.
}
\details{
When using this method, the approximated confidence intervals for the Weibull
parameters (based on p. 51 of Ralf Mock) can only be estimated for the
following confidence levels:
\itemize{
  \item \code{conf_level} = 0.90,
  \item \code{conf_level} = 0.95,
  \item \code{conf_level} = 0.99.}

If the distribution is not the Weibull, the confidence intervals of the
parameters are calculated using a heteroscedasticity-consistent covariance matrix.
Here it should be said that there is no statistical foundation to calculate the
standard errors for the parameters using \emph{Least Squares} in context of
\emph{Median Rank Regression}. For an accepted statistical method use MLE
(\code{\link{ml_estimation}}).
}
\examples{
# Example 1: Fitting a two-parameter Weibull:
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

df_john <- johnson_method(x = obs, event = state)
mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull",
                       conf_level = .90)

# Example 2: Fitting a three-parameter Weibull:
# Alloy T7987 dataset taken from Meeker and Escobar(1998, p. 131)
cycles   <- c(300, 300, 300, 300, 300, 291, 274, 271, 269, 257, 256, 227, 226,
              224, 213, 211, 205, 203, 197, 196, 190, 189, 188, 187, 184, 180,
              180, 177, 176, 173, 172, 171, 170, 170, 169, 168, 168, 162, 159,
              159, 159, 159, 152, 152, 149, 149, 144, 143, 141, 141, 140, 139,
              139, 136, 135, 133, 131, 129, 123, 121, 121, 118, 117, 117, 114,
              112, 108, 104, 99, 99, 96, 94)
state <- c(rep(0, 5), rep(1, 67))

df_john <- johnson_method(x = cycles, event = state)
mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull3",
                       conf_level = .90)
}
\references{
\itemize{
    \item Mock, R., Methoden zur Datenhandhabung in
  Zuverlässigkeitsanalysen, vdf Hochschulverlag AG an der ETH Zürich, 1995
    \item Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998}
}
