% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{delta_method}
\alias{delta_method}
\title{Delta Method for Parametric Lifetime Distributions}
\usage{
delta_method(p, loc_sc_params, loc_sc_varcov, distribution = c("weibull",
  "lognormal", "loglogistic"), direction = c("y", "x"))
}
\arguments{
\item{p}{a numeric value of a probability or a quantile. If the standard error
of probability is of interest a specific quantile needs to be supplied
and vice versa.}

\item{loc_sc_params}{a (named) numeric vector of estimated
(by Maximum Likelihood) location and scale parameters for a specified
distribution. The order of elements is important. First entry needs to be
the location parameter \eqn{\mu} and the second element needs to be the
scale parameter \eqn{\sigma}.}

\item{loc_sc_varcov}{a (named) numeric matrix of estimated
(by Maximum Likelihood) location and scale variances and covariances for a
specified distribution. The order of elements is important. First entry
of the diagonal needs to be the variance of the location parameter
Var(\eqn{\mu}) and the second element of the diagonal needs to be the
variance of the scale parameter Var(\eqn{\sigma}).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{direction}{a character string specifying the direction of the computed
standard errors. Must be either "y" (failure probability) or "x"
(quantile). If \code{p} is a quantile then \emph{direction} needs to be "y"
and vice versa.}
}
\value{
A numeric value with estimated standard error of failure probability
  or quantiles.
}
\description{
The delta method estimates the standard error for quantities that can be
written as non-linear functions of ML estimators like failure probabilities or
quantiles. I.e. the location-scale parameters and variance-covariance matrix
of these need to be estimated by Maximum Likelihood.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

mle <- ml_estimation(x = obs, event = state,
                     distribution = "weibull", conf_level = 0.95)
delta_prob <- sapply(obs, delta_method,
                          loc_sc_params = mle$loc_sc_coefficients,
                          loc_sc_varcov = mle$loc_sc_vcov,
                          distribution = "weibull",
                          direction = "y")
}
