% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_locations.R
\name{nest_locations}
\alias{nest_locations}
\title{Nest Location Data into a column of Tibbles}
\usage{
nest_locations(
  .,
  key_column = "Dis No",
  columns_to_nest = c("location_word", "lat", "lng"),
  keep_nested_cols = FALSE
)
}
\arguments{
\item{.}{Locationized data frame (see \code{weed::split_locations})}

\item{key_column}{Column name for Column that uniquely IDs each observation}

\item{columns_to_nest}{Column names for Columns to nest inside the mini-dataframes}

\item{keep_nested_cols}{Boolean to Keep the nested columns externally or not.}
}
\value{
Data Frame with A column of data frames
}
\description{
Nest Location Data into a column of Tibbles
}
\examples{
d <- tibble::tribble(
~value,  ~location_word,                    ~Country,    ~lat,   ~lng,
"city of new york","new york","USA",  c(40.71427, 40.6501),   c(-74.00597, -73.94958),
"kerala", "kerala", "India",c(10.41667, 8.4855), c(76.5, 76.94924),
"chennai municipality","chennai","India", c(13.08784, 12.98833),c(80.27847, 80.16578),
"san francisco", "san francisco","USA", c(37.77493, 37.33939), c(-122.41942, -121.89496))
nest_locations(d, key_column = "value")

}
