% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weco_rules.R
\name{plot.weco}
\alias{plot.weco}
\title{Plot WECO results}
\usage{
\method{plot}{weco}(x, ...)
}
\arguments{
\item{x}{A class \code{weco} vector returned from
\code{\link{weco.rule}} or \code{\link{weco.combine}}}

\item{...}{The function takes the following arguments
           \describe{
\item{start}{First point for plotting}
\item{end}{Last point for plotting}
\item{selected}{Index of data points that will be highlighted}
\item{runin}{Number of running points that will be colored differently}
\item{ref}{Boolean. If true, reference lines will be given at 1, 2 and 3
    times standard deviation}
\item{ylim}{Range of Y-axis}
\item{cols}{Color of each data point}
}}
}
\description{
Generate plot with the observed data with abnormalities identified
}
\examples{

x        <- rnorm(1000);
rst.comb <- weco.combine(x, lst.rules=list(list(1), list(2, k=9)));
plot(rst.comb, start=10, end=80, selected = c(60,70));

}
\seealso{
\code{\link{weco.rule}}, \code{\link{weco.combine}}
}

