% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weco_rules.R
\name{weco.combine}
\alias{weco.combine}
\title{Combination of WECO Rules}
\usage{
weco.combine(x, sdx = sd(x), mux = mean(x), lst.rules)
}
\arguments{
\item{x}{A vector of continuously observed data from some process}

\item{sdx}{Standard deviation of the observed data}

\item{mux}{Mean of the observed data}

\item{lst.rules}{List of rules with parameters. The first element in the list
is the rule number}
}
\value{
A vector with the same length as \code{}{x} that contains the out of
        boundary status of each point
}
\description{
Apply a combination of multiple WECO rules to continuously observed data from some
process to detect abnormal signals
}
\examples{

x         <- rnorm(1000);
rst.comb  <- weco.combine(x, lst.rules=list(list(1), list(2, k=9)));
rst.comb2 <- weco.combine(x, lst.rules=list(list(3), list(4, k=16)));

}

