# A chat-like program that also emits R fortunes.
# It requires the fortunes, tm and wordcloud packages.
library('websockets')
htmldata = '<html><head><title>R/Websockets</title></head>
<body>
<style type="text/css">
.flright {
  float: right;
  margin: 0 0 10px 10px;
  clear: right;
}
div.scroll {
  height: 200px;
  width: 500px;
  border: 1px solid #666;
  padding: 8px;
  overflow-y: scroll;
  word-wrap: break-word;
}
input[type="text"], textarea { 
  padding: 0;
  margin: 0;
  width: 516px; 
  border: 1px solid #666;
}
</style>
<script>
chattext = "";
String.prototype.startsWith = function(str){return (this.indexOf(str) === 0);}
var socket = new WebSocket("ws://localhost:7681", "chat");
try {
  socket.onopen = function() {
    document.getElementById("wsdi_status").textContent =
      " websocket connection opened ";
    document.getElementById("statustd").style.backgroundColor = "#40ff40";
  } 
  socket.onmessage = function got_packet(msg) {
    if(msg.data.startsWith("CHAT")) {
      m = msg.data.replace(/^CHAT/,"");
      chattext = m.concat("\\n",chattext);
      document.getElementById("chat").innerHTML = 
        "<pre>" + chattext + "</pre>";
    } 
    else document.getElementById("plot").src = msg.data;
  } 
  socket.onclose = function(){
    document.getElementById("wsdi_status").textContent =
      " websocket connection CLOSED ";
    document.getElementById("statustd").style.backgroundColor = "#ff4040";
  }
}
catch(ex) {document.getElementById("chat").textContent = "Error: " + ex;}

function hello() {
  socket.send(document.getElementById("msg").value);
  document.getElementById("msg").value = "";
}

function checkKey(evt)
{
  if(evt.keyCode == 13) {
    hello();
    return false;
  }
  return true;
}
</script>

<img class="flright" id="plot" alt="R Plot" width="336" height="336" src="data:image/jpg;base64,
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"/>
<h2>Chat Cloud with R Fortunes</h2>
<table><tr>
<td id="statustd">
<div id="wsdi_status"> Connection not initialized </div>
</td></tr></table>
<table><tr>
<td><input type="text" id="msg" value="" size="80" maxlength="150" onkeypress="return checkKey(event);"/>
</td></tr><tr><td>
<div id="chat" class="scroll">
</div>
</td></tr></table>
<hr />
<p>
This is a simple WebSocket chat server written in R.
Words typed in the upper small text
box will appear to all connected clients in the lower chat history box after
pressing ENTER. The R WebSocket server also periodically emits phrases from the R 
<a targe="_blank" href="http://cran.r-project.org/web/packages/fortunes/"><b>fortunes</b></a>
package. A word cloud showing words in the chat history
is also periodically updated (limited to a 
maximum of 25 words for rendering speed and legibility). The word cloud
is generated with the R 
<a target="_blank" href="http://cran.r-project.org/web/packages/wordcloud/index.html"><b>wordcloud</b></a> package.
</p>
</body>
</html>
'

if(!(require('fortunes') && require('wordcloud')))
  stop("This demo requires the 'fortunes' and 'wordcloud' packages.")

parse = function(phrase)
{
  reject = c("for", "but", "has", "such", "have", "than", "all", "herein", "that", "also",  "the", "their", "and", "then", "another", "into", "there", "are",  "thereby", "its", "because", "these", "been", "not", "they", "being", "now", "this", "those", "onto", "use", "could", "was", "were", "what", "does", "when", "where", "whereby", "wherein", "you", "who", "will", "with", "had", "some", "would")
  x = phrase
  x = gsub("([A-z])\\*","\\1",x)
  x = gsub("\\*([A-z])","\\1",x)
  x = gsub("([A-z])\\)","\\1",x)
  x = gsub("\\(([A-z])","\\1",x)
  x = gsub("([A-z]*)'","\\1",x)
  x = gsub("'([A-z]*)","\\1",x)
  x = gsub("<x>","",x)
  x = gsub(",","",x)
  x = gsub("\\[\\.*\\]","",x)
  x = gsub("\\.","",x)
  x = gsub("\"","",x)
  x = gsub(":","",x)
  x = gsub("!","",x)
  x = gsub("\\?","",x)
  x = as.data.frame(table(unique(strsplit(x," "))))
  x[,1] = levels(x[,1])
  z = unlist(sapply(reject,function(j) which(tolower(x[,1])==j)))
  if(length(z)>0) x = x[-z,]
  x[nchar(x[,1])>2,]
}

wmerge = function(x,y,low=0)
{
  z = merge(x,y,by=1,all.x=TRUE,all.y=TRUE,sort=FALSE)
  z[is.na(z)] = 0
  z[,2] = z[,2] + z[,3]
  z = z[,-3]
  z[z[,2]>low,]
}


w = createContext(webpage=static_text_service(htmldata))

f = function(DATA,WS,...)
{
  d = tryCatch(rawToChar(DATA),error=function(e) "")
  if(nrow(Words)>0) {
    Words <<-  tryCatch(wmerge(Words,parse(d)),error=function(e) Words)
  }
  x = paste("CHAT","<b>WebSocket ",WS$socket," says: </b>",d,sep="")
  websocket_broadcast(paste(x),WS$server)
}
set_callback("receive",f,w)

tf = tempfile()
Words = data.frame()

cat("Direct your local web browser to http://localhost:7681\n")

j = 1
k = round(runif(1)*20 + 5)
while(TRUE){
  service(w, timeout=1000L)
  j = j + 1
  if(j %% k == 0) {
    j = 0
    k = round(runif(1)*20 + 5)
    d = paste(fortune()[1],collapse=" ")
    low = ifelse(nrow(Words)>1000,2,0)
# I don't like ifelse in R, it's not what I expect:
#    Words = ifelse(nrow(Words)<1,parse(d),wmerge(Words,parse(d),low=low))
    if(nrow(Words)<1) Words = parse(d)
    else Words = wmerge(Words,parse(d),low=low)
    x = paste("CHAT","<b>R fortune says: </b>",d,sep="")
    websocket_broadcast(x,w)
    min.freq = min(max(Words[,2]),2)
    jpeg(file=tf, width=600,height=600,quality=100)
    devAskNewPage(ask=FALSE)
    wordcloud(Words[,1],Words[,2],vfont=c("serif","bold"),
              max.words=25, min.freq=min.freq)
    dev.off()
    p = base64encode(readBin(tf,what="raw",n=1e6))
    p = paste("data:image/jpg;base64,\n",p,sep="")
    websocket_broadcast(paste(p),w)
    file.remove(tf)
  }
}
