% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{resize}
\alias{resize}
\title{Resize an image}
\usage{
resize(filename, geometry)
}
\arguments{
\item{filename}{Character vector containing the path of images to resize.}

\item{geometry}{Scaling specification. Can be a percent, as in \code{"50\%"},
or pixel dimensions like \code{"120x120"}, \code{"120x"}, or \code{"x120"}.
Any valid ImageMagick geometry specifation can be used. If \code{filename}
contains multiple images, this can be a vector to specify distinct sizes
for each image.}
}
\description{
This does not change size of the image in pixels, nor does it affect
appearance -- it is lossless compression. This requires GraphicsMagick
(recommended) or ImageMagick to be installed.
}
\examples{
if (interactive()) {
  # Can be chained with webshot() or appshot()
  webshot("https://www.r-project.org/", "r-small-1.png") \%>\%
    resize("75\%")

  # Generate image that is 400 pixels wide
  webshot("https://www.r-project.org/", "r-small-2.png") \%>\%
    resize("400x")
}
}

