% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuum.R
\name{continuum}
\alias{continuum}
\title{Morph between two images}
\usage{
continuum(from_img, to_img, from = 0, to = 1, by = 0.1, ...)
}
\arguments{
\item{from_img}{image to start at}

\item{to_img}{image to end at}

\item{from}{starting percentage}

\item{to}{ending percentage}

\item{by}{step size}

\item{...}{arguments to pass to \code{\link[=trans]{trans()}}}
}
\value{
a list of stimuli containing each step of the continuum
}
\description{
Morph from one image to another in the specified steps.
}
\examples{
\donttest{
if (webmorph_up()) {
  stimuli <- demo_stim()
  cont <- continuum(stimuli$f_multi, stimuli$m_multi)
  
  # create an animated gif
  animate(cont, fps = 10, rev = TRUE)
}
}
}
\seealso{
WebMorph.org functions
\code{\link{avg}()},
\code{\link{loop}()},
\code{\link{symmetrize}()},
\code{\link{trans}()},
\code{\link{webmorph_up}()}
}
\concept{webmorph}
