% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app-process.R
\name{new_app_process}
\alias{new_app_process}
\alias{webfakes_app_process}
\title{Run a webfakes app in another process}
\usage{
new_app_process(
  app,
  port = NULL,
  opts = server_opts(remote = TRUE),
  start = FALSE,
  auto_start = TRUE,
  process_timeout = 5000,
  callr_opts = NULL
)
}
\arguments{
\item{app}{\code{webfakes_app} object, the web app to run.}

\item{port}{Port to use. By default the OS assigns a port.}

\item{opts}{Server options. See \code{\link[=server_opts]{server_opts()}} for the defaults.}

\item{start}{Whether to start the web server immediately. If this is
\code{FALSE}, and \code{auto_start} is \code{TRUE}, then it is started as neeed.}

\item{auto_start}{Whether to start the web server process automatically.
If \code{TRUE} and the process is not running, then \verb{$start()},
\verb{$get_port()} and \verb{$url()} start the process.}

\item{process_timeout}{How long to wait for the subprocess to start, in
milliseconds.}

\item{callr_opts}{Options to pass to \code{\link[callr:r_session_options]{callr::r_session_options()}}
when setting up the subprocess.}
}
\value{
A \code{webfakes_app_process} object.
\subsection{Methods}{

The \code{webfakes_app_process} class has the following methods:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{get_app()
get_port()
stop()
get_state()
local_env(envvars)
url(path = "/", query = NULL)
}\if{html}{\out{</div>}}
\itemize{
\item \code{envvars}: Named list of environment variables. The \code{{url}} substring
is replaced by the URL of the app.
\item \code{path}: Path to return the URL for.
\item \code{query}: Additional query parameters, a named list, to add to the URL.
}

\code{get_app()} returns the app object.

\code{get_port()} returns the port the web server is running on.

\code{stop()} stops the web server, and also the subprocess. If the error
log file is not empty, then it dumps its contents to the screen.

\code{get_state()} returns a string, the state of the web server:
\itemize{
\item \code{"not running"} the server is not running (because it was stopped
already).
\item \code{"live"} means that the server is running.
\item \code{"dead"} means that the subprocess has quit or crashed.
}

\code{local_env()} sets the given environment variables for the duration of
the app process. It resets them in \verb{$stop()}. Webfakes replaces \code{{url}}
in the value of the environment variables with the app URL, so you can
set environment variables that point to the app.

\code{url()} returns the URL of the web app. You can use the \code{path}
parameter to return a specific path.
}
}
\description{
Runs an app in a subprocess, using \link[callr:r_session]{callr::r_session}.
}
\examples{
app <- new_app()
app$get("/foo", function(req, res) {
  res$send("Hello world!")
})

proc <- new_app_process(app)
url <- proc$url("/foo")
resp <- curl::curl_fetch_memory(url)
cat(rawToChar(resp$content))

proc$stop()
}
\seealso{
\code{\link[=local_app_process]{local_app_process()}} for automatically cleaning up the
subprocess.
}
