% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_smiles_inchi}
\alias{cs_smiles_inchi}
\title{Convert a SMILES to InChI}
\usage{
cs_smiles_inchi(smiles, verbose = TRUE, ...)
}
\arguments{
\item{smiles}{character, A SMILES string}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
A SMILES string
}
\description{
Convert a SMILES to InChI
}
\examples{
\donttest{
# might fail if API is not available
smiles <- "CN1CC[C@]23[C@H]4C=C[C@H]([C@H]3Oc3c(ccc(C[C@H]14)c23)O)O"
# convert smiles to inchi
cs_smiles_inchi(smiles)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

