% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trophicSDMfit.R
\name{plot.trophicSDMfit}
\alias{plot.trophicSDMfit}
\title{Plots the regression coefficients of a fitted trophicSDM model}
\usage{
\method{plot}{trophicSDMfit}(x, species = NULL, ...)
}
\arguments{
\item{x}{A trophicSDMfit object obtained with trophicSDM()}

\item{species}{A vector of species names to be plot. If NULL (default), all species are plotted.}

\item{...}{additional arguments}
}
\value{
A plot of the regression coefficients of the fitted tropic SDM
}
\description{
Plots the regression coefficients of a fitted trophicSDM model. A subset of species to be plotted can be specified in the parameter\code{species}.
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 50,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
# Plot just the first three species
\donttest{
plot(m, species = c("Y1","Y2","Y3"))
}
# If species = NULL (default), all species are plotted.
}
\author{
Giovanni Poggiato
}
