% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SDMfit.R
\name{plot.SDMfit}
\alias{plot.SDMfit}
\title{Plots the regression coefficients of a local model}
\usage{
\method{plot}{SDMfit}(x, level = 0.95, ...)
}
\arguments{
\item{x}{A SDMfit object, typically obtained with trophicSDM() and available in the field $model of a trophicSDMfit object}

\item{level}{the confidence level of the confidence intervals}

\item{...}{additional arguments}
}
\value{
A plot of the regression coefficients of the fitted local SDM
}
\description{
Plots the regression coefficients of a local SDMfit model
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 50,
               family = binomial(link = "logit"), penal = NULL,
               mode = "prey", method = "stan_glm")
# Plot species Y6
\donttest{
plot(m$model$Y6)
}
}
\author{
Giovanni Poggiato
}
