#' wdpar: Interface to the World Database on Protected Areas
#'
#' The \pkg{wdpar} R package provides an interface to the World Database on
#' Protected Areas (WDPA). It provides functions for automatically downloading
#' data (from [Protected Planet](http://protectedplanet.net)) and cleaning
#' data following best practices (outlined in Butchart *et al.* 2015;
#' Runge *et al.* 2015). The main functions are [wdpa_fetch()]
#' for downloading data and [wdpa_clean()] for cleaning data. For
#' more information, please see the package vignette.
#'
#' @references
#' Butchart SH, Clarke M, Smith RJ, Sykes RE, Scharlemann JP,
#' Harfoot M, ... & Brooks TM (2015) Shortfalls and solutions for
#' meeting national and global conservation area targets.
#' *Conservation Letters*, **8**: 329--337.
#'
#' Runge CA, Watson JEM, Butchart HM, Hanson JO, Possingham HP & Fuller RA
#' (2015) Protected areas and global conservation of migratory birds.
#' *Science*, **350**: 1255--1258.
#'
#' @name wdpar
#'
#' @docType package
NULL

#' @import sf
NULL
