% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{match_funs}
\alias{match_funs}
\alias{match_sections}
\alias{match_services}
\alias{match_layers}
\title{Find available sections, services, or layers using a regular expression}
\usage{
match_sections(...)

match_services(..., sections = NULL, pull = TRUE)

match_layers(..., sections = NULL, services = NULL, pull = TRUE)
}
\arguments{
\item{...}{Character vector or regular expression to match on}

\item{sections}{A character vector of available sections to subset by}

\item{pull}{Logical. Pull unique values (TRUE, default) or show the matching
rows in the service_urls data.frame}

\item{services}{A character vector of available services to subset by}
}
\value{
A character vector of all matching sections, services, or layers
appropriate to the called function
}
\description{
These functions allow you to search for sections, services, or layers that
are available in the WDNR ArcGIS REST API using a regular expression. This
is useful when you don't know the full name of a section, service, or
layer but want to search based on keywords
}
\examples{
match_sections("WT")
match_services("Fish", sections = match_sections("WT"))
match_layers("Fish", sections = match_sections("WT"))
}
