% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpanet_general.R
\name{rpanet_general}
\alias{rpanet_general}
\title{Generate a PA network with non-linear preference functions}
\usage{
rpanet_general(
  nstep,
  initial.network,
  control,
  directed,
  m,
  sum_m,
  w,
  nnode,
  nedge,
  method,
  sample.recip
)
}
\arguments{
\item{nstep}{Number of steps when generating a network.}

\item{initial.network}{A list represents the seed network. If \code{NULL},
\code{initial.network} will have one edge from node 1 to node 2 with weight
1. It consists of the following components: a two column matrix
\code{edgelist} represents the edges; a vector \code{edgeweight} represents
the weight of edges; a integer vector \code{nodegroup} represents the group
of nodes. \code{nodegroup} is defined for directed networks, if
\code{NULL}, all nodes from the seed graph are considered from group 1.}

\item{control}{A list of parameters that controls the PA generation process.
The default value is \code{rpa_control_scenario() +
rpa_control_edgeweight() + rpa_control_newedge() + rpa_control_preference()
+ rpa_control_reciprocal()}. By default, in each step, a new edge of weight
1 is added from a new node \code{A} to an existing node \code{B}
(\code{alpha} scenario), where $\code{B} is chosen with probability
proportional to its in-strength + 1.}

\item{directed}{Logical, whether to generate directed networks. If
\code{FALSE}, the edge directions are ignored.}

\item{m}{Integer vector, number of new edges in each step.}

\item{sum_m}{Integer, summation of \code{m}.}

\item{w}{Vector, weight of new edges.}

\item{nnode}{Integer, number of nodes in \code{initial.network}.}

\item{nedge}{Integer, number of edges in \code{initial.network}.}

\item{method}{Which method to use when generating PA networks: "binary" or
"linear".}

\item{sample.recip}{Whether reciprocal edges will be added.}
}
\value{
A list with the following components: \code{edgelist};
  \code{edgeweight}; number of new edges in each step \code{newedge}
  (reciprocal edges are not included); \code{node.attribute}, including node
  strengths, preference scores and node group (if applicable); control list
  \code{control}; edge scenario \code{scenario} (1~alpha, 2~beta, 3~gamma,
  4~xi, 5~rho, 6~reciprocal). The edges from \code{initial.network} are
  denoted as scenario 0.
}
\description{
Generate a PA network with non-linear preference functions
}
\keyword{internal}
