% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbs.R
\name{wbs}
\alias{wbs}
\alias{wbs.default}
\title{Change-point detection via Wild Binary Segmentation}
\usage{
wbs(x, ...)

\method{wbs}{default}(x, M = 5000, rand.intervals = TRUE,
  integrated = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{...}{not in use}

\item{M}{a number of intervals used in the WBS algorithm}

\item{rand.intervals}{a logical variable; if \code{rand.intervals=TRUE} intervals used in the procedure are random, thus
the output of the algorithm may slightly vary from run to run;  for \code{rand.intervals=FALSE} the intervals used depend on \code{M} and the length of \code{x} only,
hence the output is always the same for given input parameters}

\item{integrated}{a logical variable indicating the version of Wild Binary Segmentation algorithm used; when \code{integrated=TRUE}, 
augmented version of WBS is launched, which combines WBS and BS into one}
}
\value{
an object of class "wbs", which contains the following fields
\item{x}{the input vector provided}
\item{n}{the length of \code{x}}
\item{M}{the number of intervals used}
\item{rand.intervals}{a logical variable indicating type of intervals}
\item{integrated}{a logical variable indicating type of WBS procedure}
\item{res}{a 6-column matrix with results, where 's' and 'e' denote start-
end points of the intervals in which change-points candidates 'cpt' have been found;
column 'CUSUM' contains corresponding value of CUSUM statistic; 'min.th' is the smallest 
threshold value for which given change-point candidate would be not added to the set of estimated 
change-points; the last column is the scale at which the change-point has been found}
}
\description{
The function applies the Wild Binary Segmentation algorithm to identify potential locations of the change-points in the mean of the input vector \code{x}. 
The object returned by this routine can be further passed to the \code{\link{changepoints}} function, 
which finds the final estimate of the change-points based on chosen stopping criteria.
}
\examples{
x <- rnorm(300) + c(rep(1,50),rep(0,250))
w <- wbs(x)
plot(w)
w.cpt <- changepoints(w)
w.cpt
th <- c(w.cpt$th,0.7*w.cpt$th) 
w.cpt <- changepoints(w,th=th)
w.cpt$cpt.th
}
