% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalties.R
\name{ssic.penalty}
\alias{ssic.penalty}
\title{Strengthened Schwarz Information Criterion penalty term}
\usage{
ssic.penalty(n, cpt, alpha = 1.01, ssic.type = c("log", "power"))
}
\arguments{
\item{n}{the number of observations}

\item{cpt}{a vector with localisations of change-points}

\item{alpha}{a scalar greater than one}

\item{ssic.type}{a string ("log" or "power")}
}
\value{
the penalty term \eqn{k(\log(n))^{alpha}}{k(log(n))^(alpha)} for \code{ssic.penalty="log"} or \eqn{k n^{alpha}}{k * n^(alpha)} for \code{ssic.penalty="power"}, where \eqn{k}{k} denotes the number of elements in \code{cpt}
}
\description{
The function evaluates the penalty term for the strengthened Schwarz Information Criterion proposed in P. Fryzlewicz (2014). This routine is typically not called directly by the user; its name can be passed as an argument to \code{\link{changepoints}}.
}
\examples{
x <- rnorm(300) + c(rep(1,50),rep(0,250))
w <- wbs(x)
w.cpt <- changepoints(w,penalty="ssic.penalty")
w.cpt$cpt.ic
}
\references{
P. Fryzlewicz (2014), Wild Binary Segmentation for multiple change-point detection. Annals of Statistics, to appear. (\url{http://stats.lse.ac.uk/fryzlewicz/wbs/wbs.pdf})
}
