% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_wq.R
\name{Map_WQ_basemap}
\alias{Map_WQ_basemap}
\title{Create waterquality Map with Bing basemap}
\usage{
Map_WQ_basemap(
  WQ_extent,
  sample_points,
  map_title,
  WQ_parameter,
  points_style = "quantile",
  histogram = TRUE
)
}
\arguments{
\item{WQ_extent}{geospatial file (vector or raster) used to extract aerial imagery from Bing basemaps}

\item{sample_points}{geospatial file (.shp or .gpkg) containing sampling locations}

\item{map_title}{text used to generate title of map}

\item{WQ_parameter}{text referring to column heading of data being mapped (i.e. Chl-a, PC, etc.)}

\item{points_style}{method to process the color scale when col is a numeric variable. Please refer to the style argument in the ?tmap::tm_raster() function for more details (Default is "quantile").}

\item{histogram}{Option to add or remove a histogram of the data values. (Default is TRUE)}
}
\value{
A data visualization of the results
}
\description{
This function wraps the tmap package to help users generate fast and simple
data visualization of using bing basemaps along with optional geospatial objects and histogram
}
\seealso{
Other Map_WQ models: 
\code{\link{Map_WQ_raster}()}
}
\concept{Map_WQ models}
