% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCommitteeMembers.R
\name{getCommitteeMembers}
\alias{getCommitteeMembers}
\title{Get committee members}
\usage{
getCommitteeMembers(
  biennium,
  agency = c("House", "Senate"),
  name,
  paired = FALSE,
  type = c("df", "list", "xml")
)
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{agency}{One of "House" or "Senate", or a vector with these as its
elements.}

\item{name}{Character vector of committee names. To get the committee names
for a particular session, see \code{\link{getCommittees}}.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getCommitteeMembers} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get committee members
}
\examples{
## get all committee members for a select number of committees and years
years <- c("2011-12","2013-14")
comms <- c("Education","Judiciary")

getCommitteeMembers(years, agency = "House", comms, paired = TRUE)
}
