% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{sshape_heuristic}
\alias{sshape_heuristic}
\title{S-Shape Heuristic for the Picker’s Route Designation}
\usage{
sshape_heuristic(arcs)
}
\arguments{
\item{arcs}{A data frame or matrix representing the arcs (edges) in the warehouse.}
}
\value{
A matrix of arcs after applying the S-shape heuristic, where traversal alternates between aisles, and I/O points are added.
}
\description{
This heuristic generates an S-shape traversal solution for the picker’s route designation in a warehouse by alternating traversal directions across aisles and ensuring no crossovers between top and bottom rows.
}
\details{
The S-shape heuristic removes unnecessary arcs and ensures a consistent traversal direction across the aisles. If an odd number of aisles is found, the last aisle is treated separately, and I/O points are added.
}
\examples{
coordinates <- matrix(c(1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5,
                       0, 4, 11, 0, 10, 11, 0, 1, 5, 11, 0, 4, 11, 0, 4,
                       11), ncol = 2, byrow = FALSE,
                       dimnames = list(NULL, c("x", "y")))
sshape_heuristic(create_arcs(coordinates))


}
\references{
Dmytrów, K. (2022). Analytical and simulation determination of order picking time in a low storage warehouse for shared storage systems. Operations Research and Decisions, 32(2), 34–51. \doi{10.37190/ord220203}

Le-Duc, T. (2005). Design and Control of Efficient Order. Erasmus Research Institute of Management (ERIM).

Tarczyński, G. (2012). Analysis of the Impact of Storage Parameters and the Size of Orders on the Choice of the Method for Routing Order Picking. Operations Research and Decisions, 22(4), 105–120. \doi{10.5277/ord120406}
}
\seealso{
\code{\link{midpoint_heuristic}}, \code{\link{return_heuristic}}
}
\author{
Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}

Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}
}
