% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_wavs.R
\name{fix_wavs}
\alias{fix_wavs}
\title{Fix .wav files to allow importing them into R}
\usage{
fix_wavs(checksels = NULL, files = NULL, samp.rate = NULL, bit.depth = NULL,
 path = NULL, mono = FALSE)
}
\arguments{
\item{checksels}{Data frame with results from \code{\link{check_sels}}. Default is \code{NULL}. If  both 'checksels' and 'files' are \code{NULL}
then all files in 'path' are converted. Note that it only fixes/convert sound files in .wav format.}

\item{files}{Character vector with the names of the .wav files to fix. Default is \code{NULL}. If  both 'checksels' and 'files'  are \code{NULL}
then all files in 'path' are converted.}

\item{samp.rate}{Numeric vector of length 1 with the sampling rate (in kHz) for output files. Default is \code{NULL}.
(remain unchanged).}

\item{bit.depth}{Numeric vector of length 1 with the dynamic interval (i.e. bit depth) for output files.
Default is \code{NULL} (remain unchanged).}

\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{mono}{Logical indicating if stereo (2 channel) files should be converted to mono (1 channel). Default is \code{FALSE} (remain unchanged).}
}
\value{
A folder inside the working directory (or path provided) all 'converted_sound_files', containing
sound files in a format that can be imported in R.
}
\description{
\code{fix_wavs} fixes sound files in .wav format so they can be imported into R.
}
\details{
This function aims to simplify the process of converting sound files that cannot be imported into R and/or homogenizing sound files. Problematic files can be determined using \code{\link{check_wavs}} or \code{\link{check_sels}}. The
\code{\link{check_sels}} output can be directly input using the argument 'checksels'. Alternatively a vector of file
names to be "fixed" can be provided (argument 'files'). If neither of those 2 are provided the function will convert
all .wav sound files in the working directory to the specified sample rate/bit depth. Files are saved in a new directory
('converted_sound_files'). Internally the function calls \href{https://sourceforge.net/projects/sox/}{SOX} (\href{https://sourceforge.net/projects/sox/}{SOX} must be installed). If  both 'checksels' and 'files' are \code{NULL}
then all files in 'path' are converted. Note that it only fixes/convert sound files in .wav format.
}
\examples{
\dontrun{
# Load example files and save to temporary working directory
#

# check this folder
tempdir()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
