% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/coor.graph.R
\name{coor.graph}
\alias{coor.graph}
\title{Coordinated singing graphs}
\usage{
coor.graph(X, only.coor = FALSE, ovlp = TRUE, xl = 1,  res= 80, it = "jpeg", img = TRUE)
}
\arguments{
\item{X}{Data frame containing columns for singing event (sing.event),
individual (indiv), and start and end time of signal (start and end).}

\item{only.coor}{Logical. If \code{TRUE} only the segment in which both individuals are singing is
included (solo singing is removed). Default is \code{FALSE}.}

\item{ovlp}{Logical. If \code{TRUE} the vocalizations that overlap in time are highlighted.
Default is \code{TRUE}.}

\item{xl}{Numeric vector of length 1, a constant by which to scale
spectrogram width. Default is 1.}

\item{res}{Numeric argument of length 1. Controls image resolution. Default is 80.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{img}{Logical argument. If \code{FALSE}, image files are not produced. Default is \code{TRUE}.}
}
\value{
Graphs of the singing events in the input data frame are saved in the working directory.
}
\description{
\code{coor.graph} creates graphs of coordinated singing and highlights the signals that overlap
in time. The signals are represented by polygons of different colors.
}
\details{
This function provides visualization for coordination of acoustic signals. Signals are shown as
polygon across a time axis. It also shows which signals overlap, the amount of overlap, and
highlights the individual responsible for the overlap using a color code. The width of the polygons
depicting the time of overlap.
}
\examples{
\dontrun{

# First set temporary folder
setwd(tempdir())

# load simulate singing events  (see data documentation)
data(coor.sing)

# make coor.graphs in tiff format
coor.graph(X = coor.sing, ovlp = T, only.coor = F, xl =2, res =80, it = "jpeg" , img = TRUE)


#' # make coor.graphs in graphic device format
coor.graph(X = coor.sing, ovlp = T, only.coor = F, img = FALSE)
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/})
}

