% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wTO.Consensus.R
\name{wTO.Consensus}
\alias{wTO.Consensus}
\alias{Consensus}
\title{wTO.Consensus}
\usage{
wTO.Consensus(data)
}
\arguments{
\item{data}{list of data.frame containing the "Node.1", "Node.2" and "wTO".}
}
\description{
Consensus requires a list of data.frame containing the pair of nodes, and the wTO values for all networks that need to be joined.
#@import stringr
#@import plyr
}
\examples{

EXAMPLE =  wTO.Complete( k =2, n = 10, Data = ExampledfExpression,
Overlap = ExampleGRF$x, method = "p")

\dontrun{# Selection of only the significative ones for the Consensus.
# This is just a toy example. It does not make sense to make a consensus
# network out of the |wTO| and wTO.}
 Ex_k1_cor_p_boot_p005_sig = subset(EXAMPLE$wTO, EXAMPLE$wTO$pval < 0.05)
 Ex_k1_cor_p_boot_p005_abs = subset(EXAMPLE$abs.wTO, EXAMPLE$abs.wTO$pval < 0.05)
\dontrun{# Constructing the consensus network}
CONS = wTO.Consensus(data = list(Ex_k1_cor_p_boot_p005_sig, Ex_k1_cor_p_boot_p005_abs))
}
