% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dftotable.R
\name{dftoHTML}
\alias{dftoHTML}
\title{Data Frame to HTML Function}
\usage{
dftoHTML(
  data,
  out = NA,
  file = NA,
  note = NA,
  note.align = "l",
  anchor = NA,
  col.width = NA,
  col.align = NA,
  row.names = FALSE,
  no.escape = NA
)
}
\arguments{
\item{data}{Data set; accepts any format with column names.}

\item{out}{Determines where the completed table is sent. Set to \code{"browser"} to open HTML file in browser using \code{browseURL()}, \code{"viewer"} to open in RStudio viewer using \code{viewer()}, if available, or \code{"htmlreturn"} to return the HTML code. Defaults to Defaults to \code{"viewer"} if RStudio is running and \code{"browser"} if it isn't.}

\item{file}{Saves the completed variable table file to HTML with this filepath. May be combined with any value of \code{out}.}

\item{note}{Table note to go after the last row of the table.}

\item{note.align}{Alignment of table note, l, r, or c.}

\item{anchor}{Character variable to be used to set an \code{<a name>} tag for the table.}

\item{col.width}{Vector of page-width percentages, on 0-100 scale, overriding default column widths in HTML table. Must have a number of elements equal to the number of columns in the resulting table.}

\item{col.align}{Vector of 'left', 'right', 'center', etc. to be used with the HTML table text-align attribute in each column. If you want to get tricky, you can add a \code{";"} afterwards and keep putting in whatever CSS attributes you want. They will be applied to the whole column.}

\item{row.names}{Flag determining whether or not the row names should be included in the table. Defaults to \code{FALSE}.}

\item{no.escape}{Vector of column indices for which special characters should not be escaped (perhaps they include markup text of their own).}
}
\description{
This function takes a data frame or matrix with column names and outputs an HTML table version of that data frame.
}
\details{
This function is designed to feed HTML versions of variable tables to \code{vtable()}, \code{sumtable()}, and \code{labeltable()}.

Multi-column cells are supported. Set the cell's contents to \code{"content_MULTICOL_c_5"} where "content" is the content of the cell, "c" is the cell's alignment (l, c, r), and 5 is the number of columns to span. Then fill in the cells that need to be deleted to make room with "DELETECELL".

If the first column and row begins with the text "HEADERROW", then the first row will be put above the column names.
}
\examples{

if(interactive()) {
df <- data.frame(var1 = 1:4,var2=5:8,var3=c('A','B','C','D'),
    var4=as.factor(c('A','B','C','C')),var5=c(TRUE,TRUE,FALSE,FALSE))
dftoHTML(df,out="browser")
}

}
