% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{vsts_get_build_defs}
\alias{vsts_get_build_defs}
\title{Visual Studio Project Build Definition Information}
\usage{
vsts_get_build_defs(domain, project, auth_key, query = NULL)
}
\arguments{
\item{domain}{the location of the visual studio server}

\item{project}{the name of the project in \code{domain} to look at}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}

\item{query}{a list of extra parameters that can be sent to the API call:
\describe{
\item{revision}{[integer] The revision number to retrieve. If this is not specified, the latest version will be returned.}
\item{minMetricsTime}{[string] If specified, indicates the date from which metrics should be included.}
\item{propertyFilters}{[string] A comma-delimited list of properties to include in the results.}
\item{includeLatestBuilds}{[logical]}
}}
}
\description{
These functions will allow you to scrape build definition information from Visual Studio.
}
\details{
For more information about the build definition API calls check
\url{https://docs.microsoft.com/en-us/rest/api/vsts/build/definitions}.
}
\examples{
#Add in own details to get a non-NULL output
auth_key <- vsts_auth_key('<username>', '<password>')
vsts_get_build_defs('domain', 'project', auth_key)

}
