% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsp.R
\name{vsp}
\alias{vsp}
\alias{vsp.default}
\alias{vsp.matrix}
\alias{vsp.Matrix}
\alias{vsp.dgCMatrix}
\alias{vsp.igraph}
\title{Semi-Parametric Factor Analysis via Vintage Sparse PCA}
\usage{
vsp(x, rank, ...)

\method{vsp}{default}(x, rank, ...)

\method{vsp}{matrix}(
  x,
  rank,
  ...,
  center = FALSE,
  recenter = FALSE,
  degree_normalize = TRUE,
  renormalize = FALSE,
  tau_row = NULL,
  tau_col = NULL,
  kaiser_normalize_u = FALSE,
  kaiser_normalize_v = FALSE,
  rownames = NULL,
  colnames = NULL
)

\method{vsp}{Matrix}(
  x,
  rank,
  ...,
  center = FALSE,
  recenter = FALSE,
  degree_normalize = TRUE,
  renormalize = FALSE,
  tau_row = NULL,
  tau_col = NULL,
  kaiser_normalize_u = FALSE,
  kaiser_normalize_v = FALSE,
  rownames = NULL,
  colnames = NULL
)

\method{vsp}{dgCMatrix}(
  x,
  rank,
  ...,
  center = FALSE,
  recenter = FALSE,
  degree_normalize = TRUE,
  renormalize = FALSE,
  tau_row = NULL,
  tau_col = NULL,
  kaiser_normalize_u = FALSE,
  kaiser_normalize_v = FALSE,
  rownames = NULL,
  colnames = NULL
)

\method{vsp}{igraph}(x, rank, ..., edge_weights = NULL)
}
\arguments{
\item{x}{Either a graph adjacency matrix, \link[igraph:aaa-igraph-package]{igraph::igraph} or
\link[tidygraph:tbl_graph]{tidygraph::tbl_graph}. If \code{x} is a \link{matrix} or \link[Matrix:Matrix]{Matrix::Matrix}
then \code{x[i, j]} should correspond to the edge going from node \code{i}
to node \code{j}.}

\item{rank}{The number of factors to calculate.}

\item{...}{These dots are for future extensions and must be empty.}

\item{center}{Should the adjacency matrix be row \emph{and} column centered?
Defaults to \code{FALSE}.}

\item{recenter}{Should the varimax factors be re-centered around the
original factor means? Only used when \code{center = TRUE}, defaults to \code{FALSE}.}

\item{degree_normalize}{Should the regularized graph laplacian be used instead of the
raw adjacency matrix? Defaults to \code{TRUE}. If \code{center = TRUE}, \code{A} will
first be centered and then normalized.}

\item{renormalize}{Should the regularized graph laplacian be used instead of the
raw adjacency matrix? Defaults to \code{TRUE}. If \code{center = TRUE}, \code{A} will
first be centered and then normalized.}

\item{tau_row}{Row regularization term. Default is \code{NULL}, in which case
we use the row degree. Ignored when \code{degree_normalize = FALSE}.}

\item{tau_col}{Column regularization term. Default is \code{NULL}, in which case
we use the column degree. Ignored when \code{degree_normalize = FALSE}.}

\item{kaiser_normalize_u}{Whether or not to use Kaiser normalization
when rotating the left singular vectors \code{U}. Defaults to \code{FALSE}.}

\item{kaiser_normalize_v}{Whether or not to use Kaiser normalization
when rotating the right singular vectors \code{V}. Defaults to \code{FALSE}.}

\item{rownames}{Character vector of row names of \code{x}. These row names
are propagated into the row names of the \code{U} and \code{Z}. Defaults
to \code{NULL}.}

\item{colnames}{Character vector of column names of \code{x}. These column names
are propagated into the row names of the \code{V} and \code{Y}. Defaults
to \code{NULL}.}

\item{edge_weights}{When \code{x} is an \link[igraph:aaa-igraph-package]{igraph::igraph}, an edge attribute
to use to form a weighted adjacency matrix.}
}
\value{
An object of class \code{vsp}. TODO: Details
}
\description{
This code implements TODO.
}
\details{
Sparse SVDs use \code{RSpectra} for performance.
}
\examples{

library(LRMF3)

vsp(ml100k, rank = 2)

}
