% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_roi_concentration}
\alias{vpr_roi_concentration}
\title{Calculate VPR concentrations}
\usage{
vpr_roi_concentration(
  data,
  taxas_list,
  station_of_interest,
  binSize,
  imageVolume
)
}
\arguments{
\item{data}{a VPR dataframe as produced by \code{\link{vpr_ctdroi_merge}}}

\item{taxas_list}{a list of character strings representing taxa present in the station being processed}

\item{station_of_interest}{The station being processed}

\item{binSize}{passed to \code{\link{bin_calculate}}, determines size of depth bins over which data is averaged}

\item{imageVolume}{the volume of VPR images used for calculating concentrations (mm^3)}
}
\description{
Calculates concentrations for each named taxa in dataframe
}
\examples{

data('ctd_roi_merge')
ctd_roi_merge$avg_hr <- ctd_roi_merge$time_ms /3.6e+06

taxas_list <- c('Calanus', 'krill')
binSize <- 5
station_of_interest <- 'test'
imageVolume <- 83663

taxa_conc_n <- vpr_roi_concentration(ctd_roi_merge, taxas_list,
station_of_interest, binSize, imageVolume)

}
