% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamRandomise.R
\name{gamRandomise}
\alias{gamRandomise}
\title{Generate FSL Randomise call for a GAM Model}
\usage{
gamRandomise(image, maskPath = NULL, formulaFull, formulaRed, subjData,
  outDir, nsim = 500, thresh = 0.01, run = FALSE)
}
\arguments{
\item{image}{Input path of 'nifti' image or vector of path(s) to images. If multiple paths, the script will all mergeNiftis() and merge across time.}

\item{maskPath}{to mask. Must be a binary mask}

\item{formulaFull}{Must be the formula of the full model (i.e. "~s(age,k=5)+sex+mprage_antsCT_vol_TBV")}

\item{formulaRed}{Must be the formula of the reduced model (i.e. "~sex+mprage_antsCT_vol_TBV")}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{outDir}{output directory for randomise}

\item{nsim}{Number of simulations}

\item{thresh}{significance threshold}

\item{run}{FALSE will only print randomise command but won't it}
}
\value{
Return randomise command
}
\description{
This function is able to generate all the necessary files to run randomise with a GAM Model
This script will write out all design and contrast files 
This function will run a f-test to compare a full and reduced model (a model with and without spline)
}
\examples{
\dontrun{

subjData = mgcv::gamSim(1,n=400,dist="normal",scale=2)
OutDirRoot="Output Directory"
maskName="Path to mask"
imagePath="Path to output"
covsFormula="~s(age,k=5)+sex+mprage_antsCT_vol_TBV"
redFormula="~sex+mprage_antsCT_vol_TBV"

gamRandomise(image = imagePath, maskPath = maskName, formulaFull = covsFormula, 
           formulaRed = redFormula, subjData = subjData, outDir = OutDirRoot)

}

}
