% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irv_method.R
\name{irv_method}
\alias{irv_method}
\title{Instant-Runoff Voting Method}
\usage{
irv_method(x, min_valid = 1)
}
\arguments{
\item{x}{an object of class \code{vote}.}

\item{min_valid}{default is 1. If the number of valid entries of 
a ballot is less than this value, the ballot will not be used.}
}
\value{
a list object.
\itemize{
  \item (1) \code{call} the function call.
  \item (2) \code{method} the counting method.
  \item (3) \code{candidate} candidate names.
  \item (4) \code{candidate_num} number of candidate.
  \item (5) \code{ballot_num} number of ballots in x.
  \item (6) \code{valid_ballot_num} number of ballots that are 
used to compute the result.
  \item (7) \code{winner} the winners, may be NULL.
  \item (8) \code{absolute} whether the winner wins absolute majority in the
1st round.
  \item (9) \code{other_info} the IRV may run for 2 or more rounds. So here 
the summary information of each round is recorded. The length of the list is 
equal to the number of rounds.
}
}
\description{
Instant-runoff voting (IRV) method is also 
called alternative voting, 
transferable voting, ranked-choice voting, 
single-seat ranked-choice voting, or preferential voting.
In the 1st round, the candidate with absolute majority (that 
is, with more than 50 percent) wins. If no absolute winner exists, 
the one who gets the least votes is deleted, all other 
candidates enter into the 2nd round. Again, if no 
absolute winner exists, let the one with the least votes go and 
start the 3rd round... Finally, an absolute winner will 
appear. Ties are solved with different methods in reality; however, 
this function applies the following rules: (a) if more than 
one candidate gets the least votes, let all of them go; (b) if 
all the candidates get the same number of votes in a certain round, 
then all of them are winners. Note: the function accepts 
object of class \code{vote} and the method can only be 
used when x$approval_able is TRUE, that is, there is 
no duplicated values in the score matrix; otherwise, 
the winner will be NULL.
}
\examples{
raw <- c(
   rep(c('m', 'n', 'c', 'k'), 42), rep(c('n', 'c', 'k', 'm'), 26), 
   rep(c('c', 'k', 'n', 'm'), 15), rep(c('k', 'c', 'n', 'm'), 17)
) 
raw <- matrix(raw, ncol = 4, byrow = TRUE)
vote <- create_vote(raw, xtype = 2, candidate = c('m', 'n', 'k', 'c'))
y <- irv_method(vote) # winner is k
}
