% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcn_counts.R
\name{tcn_counts}
\alias{tcn_counts}
\title{Get conversation tweet counts}
\usage{
tcn_counts(
  ids = NULL,
  token = NULL,
  endpoint = "recent",
  start_time = NULL,
  end_time = NULL,
  granularity = "day"
)
}
\arguments{
\item{ids}{List. Conversation ids.}

\item{token}{List. Twitter API tokens.}

\item{endpoint}{Character string. Twitter API v2 search endpoint. Can be either "recent" for the last 7 days or "all"
if users app has access to historical "full-archive" tweets. Default is "recent".}

\item{start_time}{Character string. Earliest tweet timestamp to return (UTC in ISO 8601 format). If NULL API will
default to 30 days before end_time. Default is NULL.}

\item{end_time}{Character string. Latest tweet timestamp to return (UTC in ISO 8601 format). If NULL API will default
to now - 30 seconds. Default is NULL.}

\item{granularity}{Character string. Granularity or period for tweet counts. Can be "day", "minute" or "hour". Default is "day".}
}
\value{
A dataframe of conversation ids and counts.
}
\description{
Return the number of tweets for conversation ids.
}
\examples{
\dontrun{
# get tweet count for conversation thread over approximately 7 days
counts <-
  tcn_counts(
    ids = "xxxxxxxx",
    token = token,
    endpoint = "all",
    start_time = "2020-09-30T01:00:00Z",
    end_time = "2020-10-07T01:00:00Z",
    granularity = "day"
  )

# total tweets per conversation id for period
counts$counts \%>\% dplyr::count(conversation_id, wt = tweet_count)
}

}
