% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plotting.R
\name{line_plot_year_mid}
\alias{line_plot_year_mid}
\title{Line plots of Vortex parameters vs years}
\usage{
line_plot_year_mid(data, project, scenario, yrmid = 1,
  params = c("PExtinct", "Nextant", "Het", "Nalleles"),
  plotpops = c("all"), save2disk = TRUE, dir_out = "Plots")
}
\arguments{
\item{data}{A df from \code{collate_dat}}

\item{project}{Vortex project name (used to name the output)}

\item{scenario}{Vortex scenario name (used to name the output)}

\item{yrmid}{The last year to plot}

\item{params}{Vortex parameters to be plotted,
default: c('PExtinct', 'Nextant', 'Het', 'Nalleles')}

\item{plotpops}{The populations to be included in the plot, default: 'all'}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: Plots}
}
\value{
Line plot(s)
}
\description{
\code{line_plot_year_mid} generates line plots of the selected Vortex parameters
for the selected populations, from year zero to yrmid. The purpose of these
plots is to 'zoom' in the initial phase of the simulations to better
appreciate dynamics of the parameters of interest.
}
\details{
Plots are ggplot objects. When \code{save2disk=TRUE} these are saved as .rda
and .pdf files
}
\examples{
# Using Pacioni et al. example data. See ?pac.clas for more details.
data(pac.clas)
lineMidPlot.st.classic <- line_plot_year_mid(data=pac.clas,
                          project='Pacioni_et_al',
                          scenario='ST_Classic',
                          yrmid=50,
                          params=c('PExtinct', 'Nextant', 'Het', 'Nalleles'),
                          save2disk=FALSE)
}
