% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_counts}
\alias{tab_counts}
\title{Output a frequency table}
\usage{
tab_counts(data, cols, col_group = NULL, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with()}

\item{col_group}{Optional, a grouping column. The column name without quotes.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate table function}
}
\value{
A volker tibble
}
\description{
The type of frequency table depends on the number of selected columns:
\itemize{
\item One column: see \link{tab_counts_one}
\item Multiple columns: see \link{tab_counts_items}
\item One column and one grouping column: see \link{tab_counts_one_grouped}
\item Multiple columns and one grouping column: see \link{tab_counts_items_grouped}
}
}
\examples{
library(volker)
data <- volker::chatgpt

tab_counts(data, sd_gender)

}
