% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_counts}
\alias{plot_counts}
\title{Output a frequency plot}
\usage{
plot_counts(data, cols, col_group = NULL, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with()}

\item{col_group}{Optional, a grouping column. The column name without quotes.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate plot function}
}
\value{
A ggplot2 plot object
}
\description{
The type of frequency plot depends on the number of selected columns:
\itemize{
\item One column: see \link{plot_counts_one}
\item Multiple columns: see \link{plot_counts_items}
\item One column and one grouping column: see \link{plot_counts_one_grouped}
\item Multiple columns and one grouping column: see \link{plot_counts_items_grouped}
}
}
\examples{
library(volker)
data <- volker::chatgpt

plot_counts(data, sd_gender)

}
