% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voom_polar.R
\name{voom_polar}
\alias{voom_polar}
\title{Convert RNA-Seq count data to a volcano3d object using 'limma voom'}
\usage{
voom_polar(
  formula,
  metadata,
  counts,
  pcutoff = 0.05,
  padj.method = "BH",
  filter_pairwise = TRUE,
  ...
)
}
\arguments{
\item{formula}{Design formula which must be of the form `~ 0 + outcome + ...`.
The 3-way outcome variable must be the first variable after the '0', and
this variable must be a factor with exactly 3 levels.}

\item{metadata}{Matrix or dataframe containing metadata as referenced by
`formula`}

\item{counts}{Matrix containing raw gene expression count data}

\item{pcutoff}{Cut-off for p-value significance}

\item{padj.method}{Can be any method available in `p.adjust` or `"qvalue"`.
The option "none" is a pass-through.}

\item{filter_pairwise}{Logical whether adjusted p-value pairwise statistical
tests are only conducted on genes which reach significant adjusted p-value
cut-off on the group likelihood ratio test}

\item{...}{Optional arguments passed to [polar_coords()]}
}
\description{
This function takes a design formula, metadata and raw count data and uses
'limma voom' to analyse the data. The results are converted to a 'volc3d'
object ready for plotting a 3d volcano plot or polar plot.
}
\examples{
if (requireNamespace("limma", quietly = TRUE) & 
    requireNamespace("edgeR", quietly = TRUE)) {
  library(limma)
  library(edgeR)
  
  counts <- matrix(rnbinom(n=1500, mu=100, size=1/0.5), ncol=15)
  cond <- factor(rep(1:3, each=5), labels = c('A', 'B', 'C'))
  cond <- data.frame(cond)
  
  polar <- voom_polar(~0 + cond, cond, counts)
  
  volcano3D(polar)
  radial_ggplot(polar)
}

}
