% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_trio.R
\name{volcano_trio}
\alias{volcano_trio}
\title{Volcano Plots for a three-way comparison}
\usage{
volcano_trio(
  polar,
  p_cutoff = 0.05,
  cutoff_criteria = "pvalue",
  fc_cutoff = 1,
  label_rows = NULL,
  label_size = 3,
  text_size = 10,
  marker_alpha = 0.7,
  marker_size = 3,
  marker_outline_colour = "white",
  marker_outline_width = 0.5,
  shared_legend_size = 1,
  sig_names = NULL,
  colour_scheme = "none",
  colours = c("salmon", "steelblue", "limegreen", "grey60"),
  fc_line = TRUE,
  p_line = TRUE,
  line_colours = c("black", "black"),
  share_axes = TRUE
)
}
\arguments{
\item{polar}{A polar object with the pvalues between groups of interest.
Created by \code{\link{polar_coords}}.}

\item{p_cutoff}{The cut-off for adjusted pvalue significance (default = 
0.05).}

\item{cutoff_criteria}{Whether to use pvalue or padj for the colour coding 
significance cutoff.}

\item{fc_cutoff}{The cut-off for fold change significance (default = 1).}

\item{label_rows}{Row numbers or names of values to be annotated/labelled
(default = NULL).}

\item{label_size}{The font size of labels (default = 3)}

\item{text_size}{The font size of text (default = 10)}

\item{marker_alpha}{The alpha parameter for markers (default = 0.7).}

\item{marker_size}{The size of markers (default = 3)}

\item{marker_outline_colour}{Colour for marker outline (default = white)}

\item{marker_outline_width}{Width for marker outline (default = 0.5)}

\item{shared_legend_size}{The size for the legend (default = 1).}

\item{sig_names}{A character vector of labels to be used for colour coding. 
If NULL c('Not Significant', \code{paste('Padj <', `p_cutoff`)},
\code{paste('|FC| >', `fc_cutoff`)},
\code{paste('Padj <', `p_cutoff`, 'and |FC| >', `fc_cutoff`)}) is used.}

\item{colour_scheme}{How to factor the colour scheme. Colour by "none" for 
significance group (by p and fold change cut-off), "upregulated" colour-
coded according to the upregulated groups, or "polar" for the significance 
group.}

\item{colours}{A character vector of colours to be used. This can be of 
length 3, 4, 7 or 8 depending on the colour coding desired. 
\itemize{
      \item If length is 3, c(a,b,c): Only the significant wings are 
      highlighted (where p>p_cutoff and abs(fc)>fc_cutoff) on the graph: 
      \itemize{
      \item a: padj <= p_cutoff & fc <= -1*fc_cutoff
     \item b: padj <= p_cutoff & fc >= fc_cutoff
      \item c: padj >  p_cutoff | abs(fc) < fc_cutoff
      }
      \item If length is 4, c(a,b,c,d): 
      \itemize{
      \item a: padj <= p_cutoff & abs(fc) >= fc_cutoff
      \item b: padj <= p_cutoff & abs(fc) < fc_cutoff
      \item c: padj > p_cutoff & abs(fc) >= fc_cutoff
      \item d: padj < p_cutoff & abs(fc) < fc_cutoff
      }
     \item If length is 7 the `polar@polar$sig` is used to colour code the 
      probes. `colour_scheme` must be set to 'polar'
      \item If length is 8 c(a,b,c,d,e,f,g,h): Each significance group is 
      colour-coded
      \itemize{
      \item a: padj <= p_cutoff & fc <= -1*fc_cutoff
      \item b: padj <=  p_cutoff & -1*fc_cutoff < fc <= 0
      \item c: padj <=  p_cutoff & 0 < fc < fc_cutoff
      \item d: padj <= p_cutoff & fc >= fc_cutoff
      \item e: padj > p_cutoff & fc <= -1*fc_cutoff
      \item f: padj >  p_cutoff & -1*fc_cutoff < fc <= 0
      \item g: padj >  p_cutoff & 0 < fc < fc_cutoff
      \item h: padj > p_cutoff & fc >= fc_cutoff
      }
  }}

\item{fc_line}{Logical whether to add vertical dashed line at fc_cutoff
(default = TRUE).}

\item{p_line}{Logical whether to add horizontal dashed line at p_cutoff
(default = TRUE).}

\item{line_colours}{A character vector stating the colour of lines to be
used for fc_line and p_line respectively (default = c('black', 'black')).}

\item{share_axes}{Logical whether plots should share axes when plotted
together.}
}
\value{
Returns a list of ggplot volcano plots. The first three elements
contain comparisons between all contrasts. The last element in the list is a
combined figure for all three plots.
}
\description{
This function creates a volcano plot for all combinations of groups in a
factor.
}
\examples{
data(example_data)
syn_polar <- polar_coords(sampledata = syn_example_meta,
                          contrast = "Pathotype",
                          groups = NULL,
                          pvalues = syn_example_p,
                          expression = syn_example_rld,
                          p_col_suffix = "pvalue",
                          padj_col_suffix = "padj",
                          non_sig_name = "Not Significant",
                          multi_group_prefix = "LRT",
                          significance_cutoff = 0.01,
                          fc_col_suffix='log2FoldChange',
                          fc_cutoff = 0.3)
syn_volcano_plots <- volcano_trio(polar=syn_polar)
syn_volcano_plots$All
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://www.cell.com/cell-reports/fulltext/S2211-1247(19)31007-1}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\concept{volcanoplot}
\keyword{hplot}
