% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\name{printARFFfile}
\alias{printARFFfile}
\title{printARFFfile: Create arff files by creating and flattening vocaldias}
\usage{
printARFFfile(
  df,
  ids = c(),
  idcolumn = "id",
  noPauseTypes = F,
  sampled = 0,
  individual = TRUE,
  nodecolumn = "role",
  classcolumn = "dx",
  file = ""
)
}
\arguments{
\item{df}{df a data frame consisting, minimally, of a column for
vocalisation/pause start times, a column for end times, and a
column identifying the speaker, speaker role or 'Floor' (for
silences).}

\item{ids}{Ids of dialogues to generate (as defined in column named idcolumn)}

\item{idcolumn}{the name of the column containing the dialogue id}

\item{noPauseTypes}{if TRUE, ignore distinctions between pauses
(SwitchingPause, GrpSwitchingPause, etc)}

\item{sampled}{if >0 use \code{\link{getSampledVocalMatrix}} with rate=sampled}

\item{individual}{whether to include individual speakers or group
them into a single Vocalisation node}

\item{nodecolumn}{the name of the column containing the node
(speaker) name (e.g. 'speaker', 'role').}

\item{classcolumn}{the name of the column containing the target class (or value).}

\item{file}{name of ARFF file to be generated, or "" (print to console).}
}
\description{
Generate ARFF files from vocalisation diagrams
}
\details{
Use this function to generate turn-taking diragrams in ARFF format for
}
\examples{
data(vocdia)
atdarff <- tempfile(pattern='vocaldia-', fileext='arff')
printARFFfile(atddia, individual=TRUE, classcolumn='dx',
              file=atdarff, noPauseTypes=FALSE)
library("foreign")
x1 <- read.arff(atdarff)
x1[1:3,]
## remove empty columns
x1[,c(unlist(apply(x1[1:(ncol(x1)-1)],2,sum)!=0), TRUE)]
}
\references{
S. Luz. Automatic identification of experts and performance
  prediction in the multimodal math data corpus through analysis
  of speech interaction. In \emph{Proceedings of the 15th ACM on
  International Conference on Multimodal Interaction, ICMI'13},
  pages 575--582, New York, NY, USA, 2013. ACM.
}
\seealso{
\code{\link{getSampledVocalCountMatrix}},
    \code{\link{getTurnTakingProbMatrix}}.
}
