% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\name{getPauseType}
\alias{getPauseType}
\title{getPauseType: name pause type between two vocalisation events.}
\usage{
getPauseType(prevspeaker, nextspeaker)
}
\arguments{
\item{prevspeaker}{speaker of the vocalisation immediately before Floor}

\item{nextspeaker}{speaker of the vocalisation immediately after Floor}
}
\value{
the pause type.
}
\description{
Identify the type of pause between vocalisations.
}
\details{
The type of pause a 'Floor' (silence) event represents can be:
'Pause', 'SwitchingPause', 'GrpPause', or 'GrpSwitchingPause'. See
(Luz, 2013) for details.
}
\examples{
getPauseType('a', 'b')
 ## [1]  "SwitchingPause"
getPauseType('a', 'Grp')
 ## [1]  "SwitchingPause"
getPauseType('Grp', 'Grp')
 ## [1]  "GrpPause"
getPauseType('Grp', 'a')
 ## [1]  "GrpSwitchingPause"
getPauseType('a', 'a')
 ##[1] "Pause"
}
\seealso{
\code{\link{namePauses}}
}
